*** Settings ***
Resource            /opt/robot-tests/tests/resources/common.resource
Library             /opt/robot-tests/tests/libraries/bodyRequests.py
Library             XML
Library             String
Resource            /opt/robot-tests/tests/resources/common/basicRequests.robot
Resource            ../../resources/common.resource
Resource            ../../resources/common/basicRequests.robot

Suite Teardown      Reset Testing Environment
Test Setup          Reset Testing Environment
Test Teardown       Reset Testing Environment


*** Variables ***
${API_INVOKER_NOT_REGISTERED}       not-valid
${SUBSCRIBER_ID_NOT_VALID}          not-valid
${SUBSCRIPTION_ID_NOT_VALID}        not-valid


*** Test Cases ***
Service API Available filtered by apiIds
    [Tags]    event_filter-1    mockserver

    # Initialize Mock server
    Init Mock Server

    # Default Invoker Registration and Onboarding
    ${register_user_info_invoker}    ${url}    ${request_body}=    Invoker Default Onboarding

    # Register APF
    ${register_user_info_provider}=    Provider Default Registration    total_aef_roles=2

    ${aef_id_1}=    Set Variable    ${register_user_info_provider['aef_roles']['${AEF_PROVIDER_USERNAME}']['aef_id']}
    ${aef_id_2}=    Set Variable    ${register_user_info_provider['aef_roles']['${AEF_PROVIDER_USERNAME}_1']['aef_id']}
    ${aef_ids}=    Create List    ${aef_id_1}    ${aef_id_2}
    ${aef_empty_list}=    Create List

    # Publish api with 2 aefIds
    ${service_api_description_published}    ${resource_url}    ${request_body}=    Publish Service Api
    ...    ${register_user_info_provider}
    ...    service_1
    ...    aef_id=${aef_ids}
    ...    api_status=${aef_empty_list}
    ...    supported_features=020

    # Register other provider
    ${register_user_info_provider_2}=    Provider Default Registration    provider_username=${PROVIDER_USERNAME}_NEW
    
    ${aef2_id_1}=    Set Variable    ${register_user_info_provider_2['aef_roles']['${AEF_PROVIDER_USERNAME}_NEW']['aef_id']}

    # Publish api with other provider
    ${service_api_description_published_2}    ${resource_url_2}    ${request_body_2}=    Publish Service Api
    ...    ${register_user_info_provider_2}
    ...    service_2
    ...    aef_id=${aef2_id_1}
    ...    api_status=${aef2_id_1}
    ...    supported_features=020

    # Discover APIs by invoker
    ${resp}=    Get Request Capif
    ...    ${DISCOVER_URL}${register_user_info_invoker['api_invoker_id']}&aef-id=${aef_id_1}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    Check Response Variable Type And Values    ${resp}    200    DiscoveredAPIs

    # # Check Results
    Dictionary Should Contain Key    ${resp.json()}    serviceAPIDescriptions
    Should Not Be Empty    ${resp.json()['serviceAPIDescriptions']}
    Length Should Be    ${resp.json()['serviceAPIDescriptions']}    1
    List Should Contain Value    ${resp.json()['serviceAPIDescriptions']}    ${service_api_description_published}

    ${api_id}=    Set Variable    ${resp.json()['serviceAPIDescriptions'][0]['apiId']}

    # Subscribe to events
    ${events_list}=    Create List    SERVICE_API_AVAILABLE    SERVICE_API_UNAVAILABLE    SERVICE_API_UPDATE
    ${event_filter}=    Create Capif Event Filter    apiIds=${api_id}
    ${event_filters}=    Create List    ${event_filter}    ${event_filter}    ${event_filter}

    ${request_body}=    Create Events Subscription
    ...    events=@{events_list}
    ...    notification_destination=${NOTIFICATION_DESTINATION_URL}/testing
    ...    supported_features=C
    ...    event_filters=${event_filters}
    ${resp}=    Post Request Capif
    ...    /capif-events/v1/${register_user_info_invoker['api_invoker_id']}/subscriptions
    ...    json=${request_body}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    # Check Results
    Check Response Variable Type And Values    ${resp}    201    EventSubscription
    ${subscriber_id}    ${subscription_id}=    Check Event Location Header    ${resp}

    # Update Request to published API
    ${service_api_description_modified}=    Create Service Api Description
    ...    service_1
    ...    aef_id=${aef_ids}
    ...    supported_features=20
    ...    api_status=${aef_ids}
    ${resp}=    Put Request Capif
    ...    ${resource_url.path}
    ...    json=${service_api_description_modified}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${APF_PROVIDER_USERNAME}

    Check Response Variable Type And Values    ${resp}    200    ServiceAPIDescription
    ...    apiName=service_1
    Dictionary Should Contain Key    ${resp.json()}    apiStatus

    # Provider Remove service_1 published API
    ${resp}=    Delete Request Capif
    ...    ${resource_url.path}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${APF_PROVIDER_USERNAME}

    Status Should Be    204    ${resp}

    # Provider 2 Remove service_1 published API
    ${resp}=    Delete Request Capif
    ...    ${resource_url_2.path}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${APF_PROVIDER_USERNAME}_NEW

    Status Should Be    204    ${resp}

    # Check Event Notifications
    ## Create check Events to ensure all notifications were received
    ${service_api_available_resources}=    Create List    ${resource_url}
    ${events_expected}=    Create Expected Events For Service API Notifications
    ...    subscription_id=${subscription_id}
    ...    service_api_available_resources=${service_api_available_resources}
    ...    event_detail_expected=${TRUE}
    ...    service_api_description_expected=${TRUE}
    ...    service_api_description=${service_api_description_modified}
    Log List    ${events_expected}

    ${events_expected}=    Create Expected Service Update Event
    ...    subscription_id=${subscription_id}
    ...    service_api_resource=${resource_url}
    ...    service_api_descriptions=${service_api_description_modified}
    ...    events_expected=${events_expected}
    Log List    ${events_expected}

    ${service_api_unavailable_resources}=    Create List    ${resource_url}
    ${events_expected}=    Create Expected Events For Service API Notifications
    ...    subscription_id=${subscription_id}
    ...    service_api_unavailable_resources=${service_api_unavailable_resources}
    ...    event_detail_expected=${TRUE}
    ...    service_api_description_expected=${TRUE}
    ...    service_api_description=${service_api_description_modified}
    ...    events_expected=${events_expected}
    Log List    ${events_expected}

    ## Check Events Expected towards received notifications at mock server
    Wait Until Keyword Succeeds    5x    5s    Check Mock Server Notification Events    ${events_expected}


Try error
    [Tags]    event_filter-2    mockserver

    # Initialize Mock server
    Init Mock Server

    # Default Invoker Registration and Onboarding
    ${register_user_info_invoker}    ${url}    ${request_body}=    Invoker Default Onboarding

    # Register APF
    ${register_user_info_provider}=    Provider Default Registration    total_aef_roles=2

    ${aef_id_1}=    Set Variable    ${register_user_info_provider['aef_roles']['${AEF_PROVIDER_USERNAME}']['aef_id']}
    ${aef_id_2}=    Set Variable    ${register_user_info_provider['aef_roles']['${AEF_PROVIDER_USERNAME}_1']['aef_id']}
    ${aef_ids}=    Create List    ${aef_id_1}    ${aef_id_2}
    ${aef_empty_list}=    Create List

    # Publish api with 2 aefIds
    ${service_api_description_published}    ${resource_url}    ${request_body}=    Publish Service Api
    ...    ${register_user_info_provider}
    ...    service_1
    ...    aef_id=${aef_ids}
    ...    api_status=${aef_empty_list}
    ...    supported_features=020

    # Register other provider
    ${register_user_info_provider_2}=    Provider Default Registration    provider_username=${PROVIDER_USERNAME}_NEW
    
    ${aef2_id_1}=    Set Variable    ${register_user_info_provider_2['aef_roles']['${AEF_PROVIDER_USERNAME}_NEW']['aef_id']}

    # Publish api with other provider
    ${service_api_description_published_2}    ${resource_url_2}    ${request_body_2}=    Publish Service Api
    ...    ${register_user_info_provider_2}
    ...    service_2
    ...    aef_id=${aef2_id_1}
    ...    api_status=${aef2_id_1}
    ...    supported_features=020

    # Discover APIs by invoker
    ${resp}=    Get Request Capif
    ...    ${DISCOVER_URL}${register_user_info_invoker['api_invoker_id']}&aef-id=${aef_id_1}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    Check Response Variable Type And Values    ${resp}    200    DiscoveredAPIs

    # # Check Results
    Dictionary Should Contain Key    ${resp.json()}    serviceAPIDescriptions
    Should Not Be Empty    ${resp.json()['serviceAPIDescriptions']}
    Length Should Be    ${resp.json()['serviceAPIDescriptions']}    1
    List Should Contain Value    ${resp.json()['serviceAPIDescriptions']}    ${service_api_description_published}

    ${api_id}=    Set Variable    ${resp.json()['serviceAPIDescriptions'][0]['apiId']}

    # Subscribe to events
    ${events_list}=    Create List    SERVICE_API_AVAILABLE    SERVICE_API_UNAVAILABLE    SERVICE_API_UPDATE
    ${event_filter}=    Create Capif Event Filter    aefIds=${aef_ids}
    ${event_filters}=    Create List    ${event_filter}    ${event_filter}    ${event_filter}

    ${request_body}=    Create Events Subscription
    ...    events=@{events_list}
    ...    notification_destination=${NOTIFICATION_DESTINATION_URL}/testing
    ...    supported_features=C
    ...    event_filters=${event_filters}
    ${resp}=    Post Request Capif
    ...    /capif-events/v1/${register_user_info_invoker['api_invoker_id']}/subscriptions
    ...    json=${request_body}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    # Check Results
    ${invalid_param}=  Create Dictionary    param=eventFilter    reason=The eventFilter {'aef_ids'} for event SERVICE_API_AVAILABLE are not applicable.
    ${invalid_param_list}=   Create List    ${invalid_param}
    Check Response Variable Type And Values
    ...    ${resp}
    ...    400
    ...    ProblemDetails
    ...    title=Bad Request
    ...    status=400
    ...    detail=Bad Param
    ...    cause=Invalid eventFilter for event SERVICE_API_AVAILABLE
    ...    invalidParams=${invalid_param_list}
